# https://www.instana.com/blog/stans-robot-shop-sample-microservice-application/
# https://github.com/instana/robot-shop

from pyparsing import *
from codeable_detectors.pyparsing_patterns import *
from codeable_detectors.project import *
from codeable_detectors.detector_context import *
from codeable_detectors.evidences import *

project = Project("Microservice Based Robot Shop", "../systems/robot-shop-master")
project.detectAndGenerateServiceModel()


# cart = project.createComponent("Cart Service", "service", "./cart", [FilesPresent(["package.json", "Dockerfile"]), AtLeastOnePresent("*.js")])
# catalogue = project.createComponent("Catalogue Service", "service", "./catalogue", [FilesPresent(["package.json", "Dockerfile"]), AtLeastOnePresent("*.js")])

# # TODO: DC/OS dir => deployment view

# # uses rabit mq ... in docker compose it composes ../payment into it ... uses instana
# dispatch = project.createComponent("Dispatch Service", "service", "dispatch", AtLeastOnePresent("./*/*.go"))

# # TODO: K8S dir => deployment view

# # TODO: load gen -> client?

# # TODO: mongo / mysql

# # TODO: openshif dir => deployment view

# # has also its own docker compose file, uses rabit mq
# payment = project.createComponent("Payment Service", "service", "payment", AtLeastOnePresent("*.py"))

# ratings = project.createComponent("Ratings Service", "service", "ratings", AtLeastOnePresent("html*/*.php"))

# shipping = project.createComponent("Shipping Service", "service", "shipping", [FilesPresent("pom.xml"), AtLeastOnePresent("src/*/*.java")])

# # TODO: Swarm => deployment view

# user = project.createComponent("User Service", "service", "./user", [FilesPresent(["package.json", "Dockerfile"]), AtLeastOnePresent("*.js")])

# apiGateway = project.createComponent("NGINX API Gateway", ["service", "facade"], "./web", [FilesPresent(["default.conf.template"]), 
#     FileContains("Dockerfile", ["(FROM\\s*nginx)", "EXPOSE\\s*"])])

# failed_evidencesCount = len(project.failed_evidences)

# def nginxLocationDetector(detectorContext, **kwargs):
#     print("************ nginx location DETECTORS ************** ")
#     args = getArgsFromKwArgs(['location', 'host'], **kwargs)

#     detectorContext.containsCurlyBracesBlock(Literal("location") + Literal(args["location"])).matches_pattern(Literal("proxy_pass") + Regex("http://.*" + args["host"] + "[^;]*") + Literal(";"))

# def dockerfileEnvVarDectector(detectorContext, **kwargs):
#     print("************ dockerfileEnvVarDectector DETECTORS ************** ")
#     args = getArgsFromKwArgs(['envVar'], **kwargs)

#     detectorContext.matches_pattern(Literal("ENV") + OneOrMore(Word(printables, excludeChars = "=\\") +
#         Literal("=") + Word(printables, excludeChars = "=\\") + Optional("\\"))).matches_pattern(Literal(args["envVar"]) +
#         Literal("=") + Word(printables, excludeChars = "=\\"))
       
# for name, componentID, hostEnvVar in [
#     ["catalogue", catalogue, "CATALOGUE_HOST"],
#     ["user", user, "USER_HOST"],
#     ["cart", cart, "CART_HOST"],
#     ["shipping", shipping, "SHIPPING_HOST"],
#     ["payment", payment, "PAYMENT_HOST"],
#     ["ratings", ratings, "RATINGS_HOST"]]:
#     project.add_links(apiGateway, componentID, {"roleName": "target", "stereotypeInstances": "restfulHTTP"},
#         "./web", [DetectInFile("default.conf.template", nginxLocationDetector, 
#             location=f"/api/{name}/", host=hostEnvVar),
#             DetectInFile("Dockerfile", dockerfileEnvVarDectector, 
#             envVar=hostEnvVar)])


# webClient = project.createComponent("REST API Client", "client", None, NoNewfailed_evidences(failed_evidencesCount, "NGINX locations for API elements"))
# project.add_links(webClient, apiGateway, {"roleName": "target", "stereotypeInstances": "restfulHTTP"}, None, NoNewfailed_evidences(failed_evidencesCount, "NGINX locations for API elements"))

# failed_evidencesCount = len(project.failed_evidences)
# webUI = project.createComponent("Web Client", "webUI", "./web", [FilesPresent(["default.conf.template"]), AtLeastOnePresent(["*static/js/*.js", "*static/*.html"])])
# project.add_links(webUI, apiGateway, {"roleName": "target", "stereotypeInstances": "http"}, None, NoNewfailed_evidences(failed_evidencesCount, "Web interface exposed through NGINX proxy"))

# #project.add_links(cart, catalogue, {"roleName": "target", "stereotypeInstances": "restfulHTTP"}, "./cart", [JSAppCallsRequestMethod("server.js", "catalogue")])

# def cartToCatalogueLinkDetector(detectorContext):
#     print("************ app.get DETECTORS ************** ")
#     detectorContext.containsObjectCallTo("app", "get").containsProcCallTo("getProduct")
#     print("************ getP DETECTORS ************** ")
#     # the matches pattern for the promise indicates the callback based invocation, the request the service invocation in it
#     detectorContext.containsJsFunction("getProduct").matches_pattern(Literal("return") + Literal("new") +
#         Literal("Promise") + roundBracesBlock + Literal(";")).containsProcCallTo("request").matchesRegex("^['\"]http://.*catalogueHost")

# project.add_links(cart, catalogue, {"roleName": "target", "stereotypeInstances": "restfulHTTP, callback"}, "./cart",
#     DetectInFile("server.js", cartToCatalogueLinkDetector)) 

# def redisDBFromJSDetector(detectorContext, **kwargs):
#     print("************ redisDBFromJSDetector ************** ")
#     args = getArgsFromKwArgs(['redisVar', 'redisClientVar'], **kwargs)
#     detectorContext.matches_pattern(Literal(args["redisVar"]) + Literal("=") + Literal("require") + Literal("(") + Literal("'") + Literal("redis") + "'" + Literal(")"))
#     detectorContext.matches_pattern(Literal(args["redisClientVar"]) + Literal("=") + Literal(args["redisVar"]) + Literal(".") + Literal("createClient"))
#     detectorContext.matches_pattern(Literal(args["redisClientVar"]) + Literal(".") +  oneOf(["setex", "get", "del"]))
#     # detect that at least one async invocation in a Promise is present too
#     detectorContext.matches_pattern(Literal("return") + Literal("new") +
#         Literal("Promise") + roundBracesBlock + Literal(";")).matches_pattern(Literal(args["redisClientVar"]) +
#         Literal(".") +  oneOf(["setex", "get", "del"]))

# def dockerComposeImageBasedService(ctx, **kwargs):
#     print("************ goFuncToConsumerRabbitChannel ************** ")
#     args = getArgsFromKwArgs(["serviceName", "image_name_prefix"], **kwargs)
#     ctx.match_indented_block(Literal("services") + Literal(":"), "no services block in docker compose file").match_indented_block(
#         Literal(args["serviceName"]) + Literal(":"), "service '" + args["serviceName"] + 
#         "' block missing in services section of docker compose file").matches_pattern(Literal("image") + Literal(":") +
#         Literal(args["image_name_prefix"]))

# cartAndAnonymousUserCountDB = project.createComponent("Cart and Anonymous User Count DB", "redisDB", "./",
#     DetectInFile("docker-compose.yaml", dockerComposeImageBasedService, serviceName = "redis", image_name_prefix = "redis"))

# project.add_links(cart, cartAndAnonymousUserCountDB, {"roleName": "target", "stereotypeInstances": "resp, synchronousConnector, callback",
#     "taggedValues": "'description': 'async callback for saving cart, sync get, del, etc. for all other db operations'"}, 
#     "./cart", 
#     DetectInFile("server.js", redisDBFromJSDetector, redisVar = "redis", redisClientVar = "redisClient"))

# def jsPrometheusImportDetector(ctx):
#     ctx.containsProcCallTo("require").matches_pattern(Word("'`\"") + Literal("prom-client") + Word("'`\""))
# failed_evidencesCount = len(project.failed_evidences)
# cartPrometheus = project.createComponent("Cart Prometheus Monitor", "monitoringComponent", "./cart", 
#     DetectInFile("server.js", jsPrometheusImportDetector))
# project.add_links(cart, cartPrometheus, {"roleName": "target", "stereotypeInstances": "inMemoryConnector"},
#     None, NoNewfailed_evidences(failed_evidencesCount, "cart prometheus link"))

# def dockerComposeContainsServiceBlock(ctx, **kwargs):
#     args = getArgsFromKwArgs(["serviceName"], **kwargs)
#     ctx.match_indented_block(Literal("services") + Literal(":"), "no services block in docker compose file").match_indented_block(
#             Literal(args["serviceName"]) + Literal(":"), "no mongo db service in docker compose file")

# def dockerfileContainsFromStatement(ctx, **kwargs):
#     args = getArgsFromKwArgs(["image"], **kwargs)
#     ctx.matches_pattern(Literal("FROM") + Literal(args["image"]) + Literal(":"))

# catalogueUsersOrdersDb = project.createComponent("Catalogue Users Orders DB", "mongoDB", "./", 
#     [DetectInFile("docker-compose.yaml", dockerComposeContainsServiceBlock, serviceName = "mongodb"), 
#     DetectInFile("./mongo/Dockerfile", dockerfileContainsFromStatement, image = "mongo")])

# def mongoDBFromJSDetector(detectorContext, **kwargs):
#     print("************ mongoDBFromJSDetector ************** ")
#     args = getArgsFromKwArgs(['mongoClientVar', 'mongoCollectionVar', 'collectionName'], **kwargs)
#     detectorContext.matches_pattern(Literal(args["mongoClientVar"]) + Literal("=") + Literal("require") + Literal("(") + Literal("'") + Literal("mongodb") + "'" + Literal(")") + Literal(".") + Literal("MongoClient"))
#     detectorContext.matches_pattern(Literal(args["mongoClientVar"]) + Literal(".") + Literal("connect") + roundBracesBlock +
#         Literal(";")).matches_pattern(Literal(args["mongoCollectionVar"]) + Literal("=") + ID + Literal(".") + Literal("collection") +
#         roundBracesBlock).matches_pattern(Word("'`\"") + Literal(args["collectionName"]) + Word("'`\""))
#     detectorContext.matches_pattern(Literal(args["mongoCollectionVar"]) + Literal(".") + oneOf(["find", "findOne", "distinct"]))
    
# project.add_links(catalogue, catalogueUsersOrdersDb, {"roleName": "target", "stereotypeInstances": "mongoWire, callback"},
#     "./catalogue", DetectInFile("server.js", mongoDBFromJSDetector, mongoClientVar = "mongoClient", mongoCollectionVar = "collection",
#     collectionName = "products"))

# print("************ detect payment gateway **************")
# failed_evidencesCount = len(project.failed_evidences)
# # evidence is a get as this is only a dummy call to paypal in the source code for now
# paymentGateway = project.createComponent("Paypal Payment Gateway", ["service", "externalComponent"], "./payment", DetectInFile("payment.py",  
#     lambda ctx: ctx.containsObjectCallTo("requests", "get").matches_pattern(Literal("PAYMENT_GATEWAY"))))
# project.add_links(payment, paymentGateway, {"roleName": "target", "stereotypeInstances": "restfulHTTP, synchronousConnector"},
#     None, NoNewfailed_evidences(failed_evidencesCount, "link payment to payment gateway"))

# def catalogueLinksDetector(detectorContext, **kwargs):
#     print("************ catalogueLinksDetector ************** ")
#     args = getArgsFromKwArgs(["target"], **kwargs)
#     # TODO: we could also check that this is in a method that has an app.route annotation, but lets keep it simple for now
#     detectorContext.matches_pattern(pythonRequestsCallPattern).matches_patterns([Literal('http://'), Literal(args["target"])])

# project.add_links(payment, user, {"roleName": "target", "stereotypeInstances": "restfulHTTP, synchronousConnector", "label": "check for users and post orders"}, "./payment",
#     DetectInFile("payment.py", catalogueLinksDetector, target = "USER")) 

# project.add_links(payment, cart, {"roleName": "target", "stereotypeInstances": "restfulHTTP, synchronousConnector"}, "./payment",
#     DetectInFile("payment.py", catalogueLinksDetector, target = "CART")) 

# def pythonPrometheusImportDetector(ctx):
#     ctx.matches_pattern(Literal("import") + Literal("prometheus_client"))
# failed_evidencesCount = len(project.failed_evidences)
# paymentPrometheus = project.createComponent("Payment Prometheus Monitor", "monitoringComponent", "./payment", 
#     DetectInFile("payment.py", pythonPrometheusImportDetector))
# project.add_links(payment, paymentPrometheus, {"roleName": "target", "stereotypeInstances": "inMemoryConnector"},
#     None, NoNewfailed_evidences(failed_evidencesCount, "payment prometheus link"))



# #
# # Instana / Open Tracing Based Tracing
# #

# # there is no real evidence for the instana component (started outside of the project) other than the links
# # to it provided below (which would fail if instana is not used anymore)
# instana = project.createComponent("Instana Agent", "tracingComponent", None, None)

# def jsRequireInstanaDetector(ctx):
#     print("************ jsRequireInstanaDetector ************** ")
#     ctx.containsProcCallTo("require").matches_pattern(Literal("@instana/collector"))

# project.add_links(cart, instana, {"roleName": "target", "stereotypeInstances": "http2"}, "./cart",
#     DetectInFile("server.js", jsRequireInstanaDetector)) 

# project.add_links(catalogue, instana, {"roleName": "target", "stereotypeInstances": "http2"}, "./catalogue",
#     DetectInFile("server.js", jsRequireInstanaDetector)) 

# project.add_links(dispatch, instana, {"roleName": "target", "stereotypeInstances": "http2"}, "./dispatch/src",
#     DetectInFile("main.go", lambda ctx: ctx.containsProcCallTo("import").
#     matches_patterns([Literal("github.com/instana/go-sensor"), Literal("github.com/opentracing/opentracing-go")])))

# project.add_links(payment, instana, {"roleName": "target", "stereotypeInstances": "http2"}, "./payment",
#     DetectInFile("payment.py", lambda ctx: ctx.matches_pattern(Literal("import") + Literal ("opentracing"))))

# project.add_links(user, instana, {"roleName": "target", "stereotypeInstances": "http2"}, "./user",
#     DetectInFile("server.js", jsRequireInstanaDetector)) 




# def pythonFunctionContainingCallDetector(ctx, **kwargs):
#     print("************ pythonFunctionContainingCallDetector ************** ")
#     args = getArgsFromKwArgs(["functionName", "callObject", "callMethod"], **kwargs)
#     errorMessage = "python function '" + args["functionName"] + "' containing call to '" + args["callObject"] + "." + args["callMethod"] + "' not detected"
#     ctx.match_indented_python_block(Literal("def") + Literal(args["functionName"]) + roundBracesBlock + Literal(":"),
#         errorMessage).containsObjectCallTo(args["callObject"], args["callMethod"])

# def goFuncToConsumerRabbitChannel(ctx, **kwargs):
#     print("************ goFuncToConsumerRabbitChannel ************** ")
#     args = getArgsFromKwArgs(["rabbitChanVar", "queueName"], **kwargs)
#     ctx.matches_pattern(Literal("go") + Literal("func") + roundBracesBlock +
#         curlyBracesBlock).containsObjectCallTo(args["rabbitChanVar"], "Consume").matches_pattern(
#         Literal('"') + Literal(args["queueName"]) + Literal('"'))

# # project.add_links(payment, dispatch, {"roleName": "target", "stereotypeInstances": "pubSubConnector, messaging",
# #     "label": "order processing queue", "taggedValues": "'publishers': [paymentService], 'subscribers': [dispatchService]"}, "./", 
# #     [DetectInFile("./payment/payment.py", pythonFunctionContainingCallDetector, functionName = "queueOrder", 
# #     callObject = "publisher", callMethod = "publish"), DetectInFile("./dispatch/src/main.go", 
# #     goFuncToConsumerRabbitChannel, rabbitChanVar = "rabbitChan", 
# #     queueName = "orders")])

# rabbitMQ = project.createComponent("Rabbit MQ", ["messageBroker", "pubSubComponent"], "./dispatch", 
#     DetectInFile("docker-compose.yaml", dockerComposeImageBasedService, serviceName = "rabbitmq", 
#     image_name_prefix = "rabbitmq"))

# project.add_links(payment, rabbitMQ, {"roleName": "target", "stereotypeInstances": "publisher",
#     "taggedValues": "'channel': 'orders'"}, "./payment", 
#     [DetectInFile("payment.py", pythonFunctionContainingCallDetector, functionName = "queueOrder", 
#     callObject = "publisher", callMethod = "publish")])
    
# project.add_links(dispatch, rabbitMQ, {"roleName": "target", "stereotypeInstances": "subscriber",
#     "taggedValues": "'channel': 'orders'"}, "./dispatch", 
#     [DetectInFile("./src/main.go", 
#     goFuncToConsumerRabbitChannel, rabbitChanVar = "rabbitChan", 
#     queueName = "orders")])


# def dockerComposeImageBasedService(ctx, **kwargs):
#     print("************ goFuncToConsumerRabbitChannel ************** ")
#     args = getArgsFromKwArgs(["serviceName", "image_name_prefix"], **kwargs)
#     ctx.match_indented_block(Literal("services") + Literal(":"), "no services block in docker compose file").match_indented_block(
#         Literal(args["serviceName"]) + Literal(":"), "service '" + args["serviceName"] + 
#         "' block missing in services section of docker compose file").matches_pattern(Literal("image") + Literal(":") +
#         Literal(args["image_name_prefix"]))
    
# ratingsAndCitiesDB = project.createComponent("Ratings and Shipping Cities DB", "mySQLDB", "./", 
#     [DetectInFile("docker-compose.yaml", dockerComposeContainsServiceBlock, serviceName = "mysql"),
#     DetectInFile("mysql/Dockerfile", dockerfileContainsFromStatement, image = "mysql")])

# def connectPhpRatingsToMySQLRatingsDB(ctx):
#     print("************ connectPhpToMySQLRatingsDB ************** ")
#     ctx.matches_pattern(Literal("function") + Literal("_dbConnect") + roundBracesBlock + curlyBracesBlock).matches_patterns(
#         [Literal("mysql") + Literal(":"), Literal("dbname") + Literal("=") + Literal("ratings")])

# project.add_links(ratings, ratingsAndCitiesDB, {"roleName": "target", "stereotypeInstances": "mySQLProtocol"},
#     "./ratings/html", DetectInFile("api.php", connectPhpRatingsToMySQLRatingsDB))

# def connectPhpRatingsToCatalogueService(ctx):
#     print("************ connectPhpRatingsToCatalogueService ************** ")
#     ctx.matches_pattern(Literal("function") + Literal("_checkSku") + roundBracesBlock + curlyBracesBlock).matches_patterns(
#         [Literal("http://catalogue")])

# project.add_links(ratings, catalogue, {"roleName": "target", "stereotypeInstances": "restfulHTTP"},
#     "./ratings/html", DetectInFile("api.php", connectPhpRatingsToCatalogueService))

# project.add_links(user, catalogueUsersOrdersDb, {"roleName": "target", "stereotypeInstances": "mongoWire, callback", "label": "users and orders"},
#     "./user", [DetectInFile("server.js", mongoDBFromJSDetector, mongoClientVar = "mongoClient", mongoCollectionVar = "usersCollection",
#     collectionName = "users"), DetectInFile("server.js", mongoDBFromJSDetector, mongoClientVar = "mongoClient", mongoCollectionVar = "ordersCollection",
#     collectionName = "orders")])

# project.add_links(user, cartAndAnonymousUserCountDB, {"roleName": "target", "stereotypeInstances": "resp, callback",
#     "label": "only used to track anonymous users"}, 
#     "./cart", 
#     DetectInFile("server.js", redisDBFromJSDetector, redisVar = "redis", redisClientVar = "redisClient"))

# def javaCartHTTPPost(ctx):
#     ctx.matches_pattern(Literal("CART_URL") + Literal("=") + OneOrMore(Word(printables, excludeChars = ";"))).matches_patterns(
#         [Literal("http://"), Literal("/shipping"), Literal("CART_ENDPOINT")])
#     ctx.matches_pattern(Literal("new") + Literal("HttpPost") + roundBracesBlock).matches_pattern(Literal("CART_URL"))
    
# project.add_links(shipping, cart, {"roleName": "target", "stereotypeInstances": "restfulHTTP"},
#     "./shipping/src/main/java/org/steveww/spark/", DetectInFile("Main.java", javaCartHTTPPost))

# def javaMySQLConnection(ctx):
#     ctx.matches_pattern(Literal("JDBC_URL ") + Literal("=") + OneOrMore(Word(printables, excludeChars = ";"))).matches_patterns(
#         [Literal("jdbc:"), Literal("mysql:"), Literal("DB_HOST")])
    
# project.add_links(shipping, ratingsAndCitiesDB, {"roleName": "target", "stereotypeInstances": "jdbc", "label" : "read only, query predefined cities table"},
#     "./shipping/src/main/java/org/steveww/spark/", DetectInFile("Main.java", javaMySQLConnection))



if project.failed_evidences != []:
    print("*** FAILED EVIDENCES / MODEL ELEMENTS NOT ADDED ***\n")
    no = 0
    for evidence in project.failed_evidences:
        no = no + 1
        print(str(no) + ": " + evidence)
    print("\n*** \n")

# print("*** RESULTING MODEL ***\n")
# print(project.genModel)
# print("*** \n")

project.save_as_file("genmodel.py")

import subprocess
subprocess.call(['python3', 'generateAll.py'])


